func _start_patch {
    { #error if no func lo_version
        float f1 f2
        string s
        readfrom (lo_version) "%f_%f%s" f1 f2 s
        if ( (@f1 < 8.4)  || \
             (@f1 == 8.4 && @f2 < 2.0)) {
            popfile
        }
    Error:
    Popfile:
    }
}
_start_patch
#DR 105191 Workaround for custom recipes

with cli func opt_CUSTOM (arglist av) {
	abstract netlist nl
	list Args custargs modlist
	string fname cmd sname errmsg s scope
	untyped ret funcp
	stream sp
	abstract view tview

	Args = (parseargs @av '{
		flags {
			-help		(boolean) 	
		}
		optional_args {
			func_args 	(string)
		}
	} '(cli_help opt custom))

	if (@Args.-help || (isnull @Args.func_args)) {
		cli_help    opt custom
		return 0
	}

	cmd = @Args.func_args
	custargs = '()
	nl = @cli_CurObjs.view._netlist

	tview = (cli_gettopview)

	lo_optstage @tview._netlist docons
	cli_custom_function_parse @cmd &custargs &fname &sname &scope
	if (isnotnull @sname) {
	    if ((isnull @scope) || (@scope == top)) {
		if (isvardef @sname) {	# case @TargetModule and the like
		    ret = (with @@sname callfuncl @fname @custargs)
		} else {	# case <lib/default>
		    ret = (with @sname callfuncl @fname @custargs)
	    	}
	    } else if (@scope == all) {
		hier_walk @nl {
		    if (isvardef @sname) {
			ret = (with @@sname callfuncl @fname @custargs)
		    } else {
			ret = (with @sname callfuncl @fname @custargs)
		    }
		}
	    } else {
		error Unknown scope @scope in custom function
	    } 
	} {
	    ret = (callfuncl @fname @custargs)
	}
	cli_clrObjs_except
	env_UPDATE
	return @ret
}

#Workaround for postread_fixup bug in opt DR 106083

func opt_dopreprocess(abstract netlist tnl) {
	# pre-processing a netlist before optimization
	global list PostProcessNetlists
	abstract netlist nnl knl nl
	abstract view v
	abstract instance ip
	int tbd
	list loops ops newops

	knl = @Netlist
	hier_walk @tnl {
		Netlist.%PreProcessDone = 1
		Netlist.%ModifiedTime = (currenttime)
	}
		
	PostProcessNetlists = '()
	with gn_genie {
		tnl = (explode_hier @tnl)
	}
	lo_setparents @tnl
	foreach nl @PostProcessNetlists {
		nl.%PreProcessDone = 0
		if (! @nl.%post_read_fixup) {
		lo_postreadgnfixup @nl
		}
		ip = @nl._view._parent
		if (rd_gn_isbb @ip) {
			ip._blackbox = 1
		}
		rd_checkportdirs @nl
		nl.%CheckPortDirs = 1
		rd_checknetlist @nl
		lo_postreadnetlist @nl
		nl.%constprop = ()
		nl.%shared = ()
		nl.%expanded = ()
		nl.%preprocess = ()
		nl.%CleanTime = (currenttime)
		nl.%PreProcessDone = 1
	}
	Netlist = @knl

	setpattern "_Z[0-9a-f]*$"
	newops = '()
	foreach ip (opt_operators @tnl) {
		if(!(matchpattern @ip._instof._cell._name)) (prepend newops @ip)
	}
	foreach ip @newops {
		v = (lo_newcopyview @ip._instof)
		ip._instof = @v
		v._parent = @ip
	}

	nnl = (lo_topnetlist @tnl)
	if @nnl.%HloopCheck (return @tnl)	/* only check once */
	nnl.%HloopCheck = 1
	loops = (lo_hloopcheck @nnl)
	if @loops {
		abstract net np
		string s

		tnl.%PreProcessDone = 0
        	loops = (map np @loops (lo_hiername @np))
		s = (if((listlen @loops) > 1) nets net)
		/* just a warning */
        	eprintf "Warning:  Feedback loops detected in %s %s\n" @s (lo_trunclist @loops)
		eprintf "(Use (lo_printloop <netname>) to see the nets involved)\n"
	}
		
	return @tnl
}


func rd_synpp(abstract netlist nl; args ppnets) {
	global list GateCount
	list nls
	list loops
	string s ss
	int t
	abstract net np
	abstract netlist nnl
	abstract view v
	abstract instance ip
	int errcnt

	if(! @nl) (return)

	/*
	 * unset flags on parent modules.  this doesn't do anything yet, but
	 * maybe we can get ralphm to call us after the parent links have been
	 * set
	 */
	nnl = @nl
	while 1 {
		nnl.%PreProcessDone = ()
		nnl.%HloopCheck = ()
		v = @nnl._view
		if @v {
			v.%PreOptDone = ()
			ip = @v._parent
			if @ip {
				nnl = @ip._netlist
				continue
			}
		}
		break
	}
	
	/* gather netlists */
	nls = (lo_getnetlists @nl)
	pl @nls

	foreach nnl @nls {
		nnl.%post_read_fixup = 1
		lo_postreadgnfixup @nnl
	}
	foreach nnl @nls {
		rd_synpp_setblackbox @nnl
	}

	GateCount = '()
	fb_findalllatches @nls
	foreach s '(LATCH LATR LATS LATRS) {
		if @GateCount.@s {
			s =  Inferred
			foreach ss '(LATCH LATR LATS LATRS) {
				if @GateCount.@ss {
					t = @GateCount.@ss
					printf "%s %d %s" @s @t @ss
					if(@t > 1) (printf s)
					s = ","
				}
			}
			println
			break
		}
	}

	if(isnull @ppnets) {
		foreach nnl @nls (nnl.%PostProcess = 1)
	} else {
		foreach nnl @nls (nnl.%PostProcess = 0)
		foreach nnl @ppnets (nnl.%PostProcess = 1)
	}

	lo_checknetlist @nl
	return @nl
}
